/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;

public enum EnumQuality {
    wretched("wretched", "Wretched Quality", 0.5f),
    poor("poor", "Poor Quality", 0.75f),
    average("average", "Average Quality", 1.0f),
    fine("fine", "Fine Quality", 1.5f),
    excellent("excellent", "Excellent Quality", 2.0f),
    superb("superb", "Superb Quality", 2.5f),
    masterwork("masterwork", "Masterwork", 3.0f),
    legendary("legendary", "Legendary", 3.5f);

    private final String unlocalized_name;
    private final float durability_modifier;

    private EnumQuality(String unlocalized_name, String descriptor, float durability_modifier) {
        this.unlocalized_name = unlocalized_name;
        this.durability_modifier = durability_modifier;
    }

    static EnumQuality get(int ordinal) {
        return EnumQuality.values()[ordinal];
    }

    public String getDescriptor() {
        return Translator.get("quality." + this.unlocalized_name);
    }

    public float getDurabilityModifier() {
        return this.durability_modifier;
    }

    public boolean isAverage() {
        return this == average;
    }

    public boolean isLowerThan(EnumQuality quality) {
        return this.ordinal() < quality.ordinal();
    }

    public boolean isHigherThan(EnumQuality quality) {
        return this.ordinal() > quality.ordinal();
    }

    public boolean isAverageOrLower() {
        return this.ordinal() <= average.ordinal();
    }

    public boolean isAverageOrHigher() {
        return this.ordinal() >= average.ordinal();
    }

    public static EnumQuality getHighestQuality() {
        return EnumQuality.get(EnumQuality.values().length - 1);
    }

    public static EnumQuality getLowest(EnumQuality first, EnumQuality second) {
        return first.isLowerThan(second) ? first : second;
    }

    public static EnumQuality getLowest(List list) {
        if (list.size() == 0) {
            return null;
        }
        EnumQuality lowest_quality = (EnumQuality)((Object)list.get(0));
        for (int i2 = 1; i2 < list.size(); ++i2) {
            lowest_quality = EnumQuality.getLowest((EnumQuality)((Object)list.get(i2)), lowest_quality);
        }
        return lowest_quality;
    }

    public static EnumQuality getHighest(EnumQuality first, EnumQuality second) {
        return first.isHigherThan(second) ? first : second;
    }

    public static EnumQuality getHighest(List list) {
        if (list.size() == 0) {
            return null;
        }
        EnumQuality highest_quality = (EnumQuality)((Object)list.get(0));
        for (int i2 = 1; i2 < list.size(); ++i2) {
            highest_quality = EnumQuality.getHighest((EnumQuality)((Object)list.get(i2)), highest_quality);
        }
        return highest_quality;
    }

    public EnumQuality getNextLower() {
        int ordinal = this.ordinal() - 1;
        if (ordinal < 0) {
            atv.setErrorMessage("getNextLower: quality is already the lowest");
            ordinal = 0;
        }
        return EnumQuality.get(ordinal);
    }

    public String toString() {
        return this.getDescriptor();
    }

    public String getUnlocalizedName() {
        return this.unlocalized_name;
    }
}

